/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.converter.internal.mimemessage;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.internet.MimePart;
import jakarta.mail.internet.MimeUtility;
import jakarta.mail.internet.ParameterList;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.simplejavamail.api.email.AttachmentResource;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.email.Recipient;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.internal.util.NamedDataSource;
import org.simplejavamail.internal.util.Preconditions;

public class MimeMessageHelper {
    private static final String CHARACTER_ENCODING = StandardCharsets.UTF_8.name();

    private MimeMessageHelper() {
    }

    static void setSubject(Email email, MimeMessage message) throws MessagingException {
        message.setSubject(email.getSubject(), CHARACTER_ENCODING);
    }

    static void setFrom(Email email, MimeMessage message) throws UnsupportedEncodingException, MessagingException {
        if (email.getFromRecipient() != null) {
            message.setFrom((Address)new InternetAddress(email.getFromRecipient().getAddress(), email.getFromRecipient().getName(), CHARACTER_ENCODING));
        }
    }

    static void setRecipients(Email email, Message message) throws UnsupportedEncodingException, MessagingException {
        for (Recipient recipient : email.getRecipients()) {
            InternetAddress address = new InternetAddress(recipient.getAddress(), recipient.getName(), CHARACTER_ENCODING);
            message.addRecipient(recipient.getType(), (Address)address);
        }
    }

    static void setReplyTo(Email email, Message message) throws UnsupportedEncodingException, MessagingException {
        Recipient replyToRecipient = email.getReplyToRecipient();
        if (replyToRecipient != null) {
            InternetAddress replyToAddress = new InternetAddress(replyToRecipient.getAddress(), replyToRecipient.getName(), CHARACTER_ENCODING);
            message.setReplyTo(new Address[]{replyToAddress});
        }
    }

    static void setTexts(Email email, MimeMultipart multipartAlternativeMessages) throws MessagingException {
        if (email.getPlainText() != null) {
            MimeBodyPart messagePart = new MimeBodyPart();
            messagePart.setText(email.getPlainText(), CHARACTER_ENCODING);
            multipartAlternativeMessages.addBodyPart((BodyPart)messagePart);
        }
        if (email.getHTMLText() != null) {
            MimeBodyPart messagePartHTML = new MimeBodyPart();
            messagePartHTML.setContent((Object)email.getHTMLText(), "text/html; charset=\"" + CHARACTER_ENCODING + "\"");
            multipartAlternativeMessages.addBodyPart((BodyPart)messagePartHTML);
        }
        if (email.getCalendarText() != null && email.getCalendarMethod() != null) {
            MimeBodyPart messagePartCalendar = new MimeBodyPart();
            messagePartCalendar.setContent((Object)email.getCalendarText(), "text/calendar; charset=\"" + CHARACTER_ENCODING + "\"; method=\"" + email.getCalendarMethod().toString() + "\"");
            multipartAlternativeMessages.addBodyPart((BodyPart)messagePartCalendar);
        }
    }

    static void setTexts(Email email, MimePart messagePart) throws MessagingException {
        if (email.getPlainText() != null) {
            messagePart.setText(email.getPlainText(), CHARACTER_ENCODING);
        }
        if (email.getHTMLText() != null) {
            messagePart.setContent((Object)email.getHTMLText(), "text/html; charset=\"" + CHARACTER_ENCODING + "\"");
        }
        if (email.getCalendarText() != null && email.getCalendarMethod() != null) {
            messagePart.setContent((Object)email.getCalendarText(), "text/calendar; charset=\"" + CHARACTER_ENCODING + "\"; method=\"" + email.getCalendarMethod().toString() + "\"");
        }
    }

    static void configureForwarding(@NotNull Email email, @NotNull MimeMultipart multipartRootMixed) throws MessagingException {
        if (email.getEmailToForward() != null) {
            MimeBodyPart fordwardedMessage = new MimeBodyPart();
            fordwardedMessage.setContent((Object)email.getEmailToForward(), "message/rfc822");
            multipartRootMixed.addBodyPart((BodyPart)fordwardedMessage);
        }
    }

    static void setEmbeddedImages(Email email, MimeMultipart multipartRelated) throws MessagingException {
        for (AttachmentResource embeddedImage : email.getEmbeddedImages()) {
            multipartRelated.addBodyPart(MimeMessageHelper.getBodyPartFromDatasource(embeddedImage, "inline"));
        }
    }

    static void setAttachments(Email email, MimeMultipart multipartRoot) throws MessagingException {
        for (AttachmentResource resource : email.getAttachments()) {
            multipartRoot.addBodyPart(MimeMessageHelper.getBodyPartFromDatasource(resource, "attachment"));
        }
    }

    static void setHeaders(Email email, Message message) throws UnsupportedEncodingException, MessagingException {
        InternetAddress address;
        for (Map.Entry header : email.getHeaders().entrySet()) {
            for (String headerValue : (Collection)header.getValue()) {
                String headerName = (String)header.getKey();
                String headerValueEncoded = MimeUtility.encodeText((String)headerValue, (String)CHARACTER_ENCODING, null);
                String foldedHeaderValue = MimeUtility.fold((int)(headerName.length() + 2), (String)headerValueEncoded);
                message.addHeader((String)header.getKey(), foldedHeaderValue);
            }
        }
        if (email.isUseDispositionNotificationTo()) {
            Recipient dispositionTo = (Recipient)Preconditions.checkNonEmptyArgument((Object)email.getDispositionNotificationTo(), (String)"dispositionNotificationTo");
            address = new InternetAddress(dispositionTo.getAddress(), dispositionTo.getName(), CHARACTER_ENCODING);
            message.setHeader("Disposition-Notification-To", address.toString());
        }
        if (email.isUseReturnReceiptTo()) {
            Recipient returnReceiptTo = (Recipient)Preconditions.checkNonEmptyArgument((Object)email.getReturnReceiptTo(), (String)"returnReceiptTo");
            address = new InternetAddress(returnReceiptTo.getAddress(), returnReceiptTo.getName(), CHARACTER_ENCODING);
            message.setHeader("Return-Receipt-To", address.toString());
        }
    }

    private static BodyPart getBodyPartFromDatasource(AttachmentResource attachmentResource, String dispositionType) throws MessagingException {
        MimeBodyPart attachmentPart = new MimeBodyPart();
        String resourceName = MimeMessageHelper.determineResourceName(attachmentResource, true);
        String fileName = MimeMessageHelper.determineResourceName(attachmentResource, false);
        attachmentPart.setDataHandler(new DataHandler((DataSource)new NamedDataSource(fileName, attachmentResource.getDataSource())));
        attachmentPart.setFileName(fileName);
        String contentType = attachmentResource.getDataSource().getContentType();
        ParameterList pl = new ParameterList();
        pl.set("filename", fileName);
        pl.set("name", fileName);
        attachmentPart.setHeader("Content-Type", contentType + pl);
        attachmentPart.setHeader("Content-ID", String.format("<%s>", resourceName));
        attachmentPart.setDisposition(dispositionType);
        return attachmentPart;
    }

    static String determineResourceName(AttachmentResource attachmentResource, boolean encodeResourceName) {
        String datasourceName = attachmentResource.getDataSource().getName();
        String resourceName = !MiscUtil.valueNullOrEmpty((Object)attachmentResource.getName()) ? attachmentResource.getName() : (!MiscUtil.valueNullOrEmpty((Object)datasourceName) ? datasourceName : "resource" + UUID.randomUUID());
        if (!MiscUtil.valueNullOrEmpty((Object)datasourceName)) {
            resourceName = MimeMessageHelper.possiblyAddExtension(datasourceName, resourceName);
        }
        return encodeResourceName ? MiscUtil.encodeText((String)resourceName) : resourceName;
    }

    @NotNull
    private static String possiblyAddExtension(String datasourceName, String resourceName) {
        String extension;
        String possibleFilename = datasourceName;
        if (!resourceName.contains(".") && possibleFilename.contains(".") && !resourceName.endsWith(extension = possibleFilename.substring(possibleFilename.lastIndexOf(".")))) {
            resourceName = resourceName + extension;
        }
        return resourceName;
    }
}

